import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/data.dart';

abstract class AuthState {
  final BuildContext context;

  AuthState(this.context);
}

class AuthStateLoggedOut extends AuthState {
  AuthStateLoggedOut(BuildContext context) : super(context);
}

class AuthStateNoNetwork extends AuthState {
  AuthStateNoNetwork(BuildContext context) : super(context);
}

class AuthStatePreparing extends AuthState {
  final AdminModel authedAdmin;

  AuthStatePreparing(BuildContext context, {required this.authedAdmin}) : super(context);
}

class AuthStateAuthed extends AuthState {
  final AdminModel authedAdmin;

  AuthStateAuthed(BuildContext context, {required this.authedAdmin}) : super(context);
}
